#pragma once

#include "CEgFileSpec.h"
#include "ArgList.h"

class Prefs {


	public:
	
		// inSysStored == true means the this pref file stored within the system (mac -> pref folder, pc -> registry),
		//    otherwise, it's stored in the current folder. 
		// ** NOTE: registry store is unimplemented (in win32), so it just stores on the cur folder
						Prefs( const char* inPrefsName, bool inSysStored );
						
		// How a Prefs file accesses the disk.  To use a pref file, Load() it first, and to save
		//    any changes of it to disk, call Store().			
		CEgErr			Load();
		CEgErr			Store();
		
		//	Returns true if the pref ID was found
		bool			GetPref( long inID, UtilStr& outData )				{ return mPrefs.GetArg( inID, outData );	}
		long			GetPref( long inID )								{ return mPrefs.GetArg( inID );				}
		
		// 	Sets the given pref to the given data.
		void			SetPref( long inID, const UtilStr& inData );
		void			SetPref( long inID, long inData );
		
		
	protected:
		UtilStr			mPrefName;
		bool			mSysStored;
		bool			mDirty;
		CEgFileSpec		mFileSpec;
		ArgList			mPrefs;
};


